#ifndef _WIN32_DCOM
#define _WIN32_DCOM
#endif

#include <windows.h>
#include <objbase.h>
#include <atlbase.h>
#include <iostream>
#include <wbemidl.h>
#include <comutil.h>


int main( int argc, char** argv )
{
	HRESULT hr = CoInitializeEx( NULL, COINIT_MULTITHREADED );
	if ( FAILED( hr ) )
	{
		std::cerr << "COM initialization failed" << std::endl;
		return -1;
	}

	// setup process-wide security context
	hr = CoInitializeSecurity( NULL, // we're not a server
							   -1, // we're not a server
							   NULL, // dito
							   NULL, // reserved
							   RPC_C_AUTHN_LEVEL_DEFAULT, // let DCOM decide
							   RPC_C_IMP_LEVEL_IMPERSONATE,
							   NULL,
							   EOAC_NONE,
							   NULL );
	if ( FAILED( hr ) )
	{
		std::cerr << "Security initialization failed" << std::endl;
		return -1;
	}

	int result = 0;
	// we're going to use CComPtr<>s, whose lifetime must end BEFORE CoUnitialize is called
	{
		// connect to WMI
		CComPtr< IWbemLocator > locator;
		hr = CoCreateInstance( CLSID_WbemAdministrativeLocator, NULL,
							CLSCTX_INPROC_SERVER,
							IID_IWbemLocator, reinterpret_cast< void** >( &locator ) );
		if ( FAILED( hr ) )
		{
			std::cerr << "Instantiation of IWbemLocator failed" << std::endl;
			return -1;
		}

		// connect to local service with current credentials
		CComPtr< IWbemServices > service;
		hr = locator->ConnectServer( L"root\\cimv2", NULL, NULL, NULL,
									 WBEM_FLAG_CONNECT_USE_MAX_WAIT,
									 NULL, NULL, &service );
		if ( SUCCEEDED( hr ) )
		{
			// execute a query
			CComPtr< IEnumWbemClassObject > enumerator;
			hr = service->ExecNotificationQuery( L"WQL", L"SELECT * FROM __InstanceModificationEvent WITHIN 10 WHERE ( TargetInstance ISA \'Win32_LogicalDisk\' ) AND ( TargetInstance.Name = \"G:\" ) ",
								     WBEM_FLAG_FORWARD_ONLY | WBEM_FLAG_RETURN_IMMEDIATELY, NULL, &enumerator );
			std::cout << "QUERY " << hr << std::endl;
			if ( SUCCEEDED( hr ) )
			{
#error "Comment out after read: program will terminate after two events; be sure not kill program by CTRL-C etc. See caveats section in article"
				int count = 0;
				do {
					CComPtr< IWbemClassObject > folder = NULL;
					ULONG retcnt = 0L;
					while ( ( hr = enumerator->Next( WBEM_INFINITE, 1L, &folder, &retcnt ) ) == WBEM_S_TIMEDOUT );
					if ( SUCCEEDED( hr ) && ( hr != WBEM_S_FALSE ) )
					{
						if ( retcnt > 0 )
						{
							count ++;
							// query returns a result - handle the event
							_variant_t var_val;
							hr = folder->Get( L"TargetInstance", 0, &var_val, NULL, NULL );
							if ( SUCCEEDED( hr ) )
							{
								IUnknown* str = var_val;
								CComPtr< IWbemClassObject > obj;
								hr = str->QueryInterface( IID_IWbemClassObject, reinterpret_cast< void** >( &obj ) );
								if ( SUCCEEDED( hr ) )
								{
									_variant_t cn;
									hr = obj->Get( L"__Class", 0, &cn, NULL, NULL );
									if ( SUCCEEDED( hr ) )
									{
										_bstr_t name = cn;
										if ( name == _bstr_t( L"Win32_LogicalDisk" ) )
										{
											_variant_t labl;
											obj->Get( L"Name", 0, &labl, NULL, NULL );
											_bstr_t vl = labl;
											std::cout << " Change to disk " << vl << std::endl;
										}
									}
								}
							}
							else
							{
								std::cerr << "IWbemClassObject::Get failed" << std::endl;
								result = -1;
							}
							break;
						}
						else
						{
							std::cout << "Enumeration empty" << std::endl;
						}
					}
					else if ( FAILED( hr ) )
							{
								std::cerr << "Error in iterating through enumeration 0x" << std::hex << hr << std::dec << std::endl;
								result = -1;
							} else std::cout << "empty" << std::endl;
				} while ( count < 2 );
			}
			else
			{
				std::cerr << "Query failed" << std::endl;
				result = -1;
			}
		}
		else
		{
			std::cerr << "Couldn't connect to service" << std::endl;
			result = -1;
		}
	}
	CoUninitialize();

	return result;
}
